function CreateArmyNephilimsHQ()
	NVMainBaseUAsDef = {}
	for i = 1,5,1 do
		UACounter = UACounter + 1
		NVMainBaseUAsDef[i] = LazyUnlimitedArmy:New({
			Player = 2,
			Area = 3500,
			AutoDestroyIfEmpty = false,
			TransitAttackMove = true,
			Formation = nil,
			PrepDefense = false,
			DestroyBridges =  false,
			LeaderFormation = nil,
			AIActive = true,
			DefendDoNotHelpHeroes = false,
			DoNotNormalizeSpeed = false,
			IgnoreFleeing = true,
			HiResJob = true
		},
		UACounter,
		UAMaxCounter
		)
		
		UnlimitedArmySpawnGenerator:New(NVMainBaseUAsDef[i],{
			Position = GetPosition("Nephilim_HQSpawnPos"..i),
			ArmySize = 12,
			SpawnCounter = 60,
			SpawnLeaders = 12,
			LeaderDesc = {
				{LeaderType = Entities.CU_Evil_LeaderBearman1, SoldierNum = 16, SpawnNum = 2, Looped = true, Experience = 3},
				{LeaderType = Entities.CU_Evil_LeaderSkirmisher1, SoldierNum = 16, SpawnNum = 2, Looped = true, Experience = 3}
			},
			Generator = "Nephilim_HQ_Tower"..i,
			FreeArea = nil,
			RefillSoldiers = false,
			RandomizeSpawn = false,
			RandomizeSpawnPoint = false,
			DoNotRemoveIfDeadOrEmpty = false
			})
		
		--NVMainBaseUAsDef[i].SpawnPos = GetPosition("Nephilim_HQSpawnPos"..i)
		NVMainBaseUAsDef[i].DefPos = GetPosition("Nephilim_HQSpawnPos"..i)
		NVMainBaseUAsDef[i].CommandDelayer = 5
		
		NVMainBaseUAsDef[i]:AddCommandLuaFunc(BetterDefBehaviorForNV,true)
	end
	
	NVMainBaseUAsAttack = {}
	for i = 1,3,1 do
		UACounter = UACounter + 1
		NVMainBaseUAsAttack[i] = LazyUnlimitedArmy:New({
			Player = 2,
			Area = 3500,
			AutoDestroyIfEmpty = false,
			TransitAttackMove = true,
			Formation = nil,
			PrepDefense = false,
			DestroyBridges =  false,
			LeaderFormation = nil,
			AIActive = true,
			DefendDoNotHelpHeroes = false,
			DoNotNormalizeSpeed = false,
			IgnoreFleeing = true,
			HiResJob = true
		},
		UACounter,
		UAMaxCounter
		)
		if i ~= 1 then
			NVMainBaseUAsAttack[i].SpawnPos = GetPosition("Nephilim_HQSpawnPos"..i+1)
			NVMainBaseUAsAttack[i].Generator = GetID("Nephilim_HQ_Tower"..i+1)
		else
			NVMainBaseUAsAttack[i].SpawnPos = GetPosition("Nephilim_HQSpawnPos"..i)
			NVMainBaseUAsAttack[i].Generator = GetID("Nephilim_HQ_Tower"..i)
		end
		
		if i == 1 then
			NVMainBaseUAsAttack[i].DefPoint = GetPosition("EndBaseLeftEntrace")
		elseif i == 2 then
			NVMainBaseUAsAttack[i].DefPoint = GetPosition("EndBaseRightEntrace")
		else
			NVMainBaseUAsAttack[i].DefPoint = GetPosition("EndBaseMidEntrace")
		end
		
		NVMainBaseUAsAttack[i].SpawnCounter = 3
		NVMainBaseUAsAttack[i].TimeToSpawn = 1
		NVMainBaseUAsAttack[i].ArmySize = 20
		NVMainBaseUAsAttack[i].NVBaseNumber = i
		NVMainBaseUAsAttack[i].currentWayPoint = 0
		NVMainBaseUAsAttack[i].GiftReiterCounter = 5
		NVMainBaseUAsAttack[i].CheckedForEnemies = false
		
		NVMainBaseUAsAttack[i]:AddCommandLuaFunc(BaseXAttackPlayerHQFromEndbase,true)
	end
	SetupEndBaseAttacks()
	EndBaseRuinTable = {[GetID("EndBaseRuin1")] = true,[GetID("EndBaseRuin2")] = true, [GetID("EndBaseRuin3")] = true}
	RuinDestroyedTrigger = Trigger.RequestTrigger(Events.LOGIC_EVENT_ENTITY_DESTROYED,nil,"EndBaseRuinDestroied",1,nil,nil)
end

function EndBaseRuinDestroied()
	local _entID = Event.GetEntityID()
	if EndBaseRuinTable[_entID] then
		local UANumber = tonumber(string.sub(Logic.GetEntityName(_entID),12,12))
		local _RuinPos = GetPosition(_entID)
		for i = 1,5,1 do
			local trooptable = {ID = AI.Entity_CreateFormation(2, Entities.PU_LeaderHeavyCavalry2, nil, 0, _RuinPos.X,_RuinPos.Y, nil, nil, 3,0),PoisonCounter = 2}
			if NVMainBaseUAsAttack[UANumber]:IsDead() ~= -1 then
				NVMainBaseUAsAttack[UANumber]:AddLeader(trooptable.ID)
			end
			table.insert(giftreiter,trooptable)
		end
		table.insert(PoisonPos, {X=_RuinPos.X;Y=_RuinPos.Y;Dauer = 20})
		Logic.CreateEffect(GGL_Effects.FXKalaPoison,_RuinPos.X,_RuinPos.Y,0)
		table.insert(PoisonPos, {X=_RuinPos.X+500;Y=_RuinPos.Y;Dauer = 20})
		Logic.CreateEffect(GGL_Effects.FXKalaPoison,_RuinPos.X+500,_RuinPos.Y,0)
		table.insert(PoisonPos, {X=_RuinPos.X-500;Y=_RuinPos.Y;Dauer = 20})
		Logic.CreateEffect(GGL_Effects.FXKalaPoison,_RuinPos.X-500,_RuinPos.Y,0)
		table.insert(PoisonPos, {X=_RuinPos.X;Y=_RuinPos.Y+500;Dauer = 20})
		Logic.CreateEffect(GGL_Effects.FXKalaPoison,_RuinPos.X,_RuinPos.Y+500,0)
		table.insert(PoisonPos, {X=_RuinPos.X;Y=_RuinPos.Y-500;Dauer = 20})
		Logic.CreateEffect(GGL_Effects.FXKalaPoison,_RuinPos.X,_RuinPos.Y-500,0)
	end
	return false
end

function SetupEndBaseAttacks()
	--1 mid
	--2 links
	--3 rechts
	if GlobalBase == 1 then
		NVMainBaseUAsAttack[1].Waypoints = {GetPosition("EndBaseMidEntrace"),GetPosition("HQ2EnemyPos"),GetPosition("Base1LowerPoint"),GetPosition("HQ1EnemyPos")}
		NVMainBaseUAsAttack[2].Waypoints = {GetPosition("EndBaseRightEntrace"),GetPosition("HQ3EnemyPos"),GetPosition("HQ3LowerPoint"),GetPosition("ArmyMovePos3"),GetPosition("HQ2EnemyPos"),GetPosition("ArmyMovePos2"),GetPosition("HQ1EnemyPos")}
		NVMainBaseUAsAttack[3].Waypoints = {GetPosition("EndBaseLeftEntrace"),GetPosition("P2_Nephilim_TribalCamp4"),GetPosition("HQ1EnemyPos")}
	elseif GlobalBase == 2 then
		NVMainBaseUAsAttack[1].Waypoints = {GetPosition("EndBaseMidEntrace"),GetPosition("HQ2EnemyPos")}
		NVMainBaseUAsAttack[2].Waypoints = {GetPosition("EndBaseRightEntrace"),GetPosition("HQ3EnemyPos"),{GetPosition("HQ3LowerPoint"),GetPosition("HQ3WestEntrance")},GetPosition("HQ2EnemyPos")}
		NVMainBaseUAsAttack[3].Waypoints = {GetPosition("EndBaseLeftEntrace"),GetPosition("P2_Nephilim_TribalCamp4"),GetPosition("HQ1EnemyPos"),GetPosition("P2_Nephilim_TribalCamp1"),GetPosition("HQ2EnemyPos")}
	else
		NVMainBaseUAsAttack[1].Waypoints = {GetPosition("EndBaseMidEntrace"),GetPosition("HQ2EnemyPos"),GetPosition("HQ3WestEntrance"),GetPosition("HQ3EnemyPos")}
		NVMainBaseUAsAttack[2].Waypoints = {GetPosition("EndBaseRightEntrace"),GetPosition("HQ3NorthEntrance"),GetPosition("HQ3EnemyPos")}
		NVMainBaseUAsAttack[3].Waypoints = {GetPosition("EndBaseLeftEntrace"),GetPosition("P2_Nephilim_TribalCamp4"),GetPosition("HQ1EnemyPos"),GetPosition("P2_Nephilim_TribalCamp1"),GetPosition("HQ2EnemyPos"),GetPosition("HQ3LowerPoint"),GetPosition("HQ3EnemyPos")}
	end
end

function BaseXAttackPlayerHQFromEndbase(self)
	if IsDead(self.Generator) and self:IsDead() == 1 then
		self.AutoDestroyIfEmpty = true
		return true
	end
	if Logic.GetWeatherState() ~= 3 then
		if self:IsIdle() then
			if Logic.GetSector(self.Leaders[1]) ~= Logic.GetSector(self.SpawnPos) then
				local OnIsland = IslandSectors[Logic.GetSector(self.Leaders[1])]
				if OnIsland then
					return false,UnlimitedArmy.CreateCommandDefend(OnIsland,10000) 
				end
			else
				--Hier Check auf currentwaypoint und dadurch den Defpoint setzen
				if self.currentWayPoint ~= 0 then
					return false, UnlimitedArmy.CreateCommandDefend(self.DefPoint, 3800)
				else
					return false, UnlimitedArmy.CreateCommandDefend(self.SpawnPos,6000) 
				end
			end
		end
	end
	if not IsDead(self.Generator) then
		UASpawnTroopsEndBase(self)
	end
	if self:IsIdle() then
		if self:GetSize(true,false) >= 1 then
			if not self.CheckedForEnemies and self.currentWayPoint ~= 0 then
				self.CheckedForEnemies = true
				return true, UnlimitedArmy.CreateCommandAttackNearestTarget(15000)
			end
			self.CheckedForEnemies = false
			self.currentWayPoint = self.currentWayPoint + 1
			if self.Waypoints[self.currentWayPoint] then
				if self.Waypoints[self.currentWayPoint].X then
					return true, UnlimitedArmy.CreateCommandMove(self.Waypoints[self.currentWayPoint])
				else
					return true, UnlimitedArmy.CreateCommandMove(self.Waypoints[self.currentWayPoint][math.random(1,2)])
				end
			else
				self.currentWayPoint = 0
				return true, UnlimitedArmy.CreateCommandMove(self.SpawnPos)
			end
		else
			self.currentWayPoint = 0
			return true, UnlimitedArmy.CreateCommandMove(self.SpawnPos)
		end
	end
	return false	
end

function UASpawnTroopsEndBase(self)
	if self:GetSize(true,false) >= self.ArmySize then
		return true
	end
	if self.SpawnCounter >= 0 then
		self.SpawnCounter = self.SpawnCounter - 1
	else
		self.SpawnCounter = self.TimeToSpawn
		local _spawnSwitch		
		local _spawnamount
		local _temp = self:GetSize(true,false)
		if _temp + 5 <= self.ArmySize then
			_spawnamount = 5
		else
			_spawnamount = self.ArmySize - _temp
		end
		for i = 1, _spawnamount, 1 do
			if _spawnSwitch then
				local leaderID = Logic.CreateEntity(Entities.CU_Evil_LeaderBearman1, self.SpawnPos.X, self.SpawnPos.Y,0,2)
				for k = 1,16,1 do
					Logic.CreateEntity(Entities.CU_Evil_SoldierBearman1, self.SpawnPos.X, self.SpawnPos.Y, 0, 2 )
					Logic.LeaderGetOneSoldier( leaderID )	
				end
				self:AddLeader(leaderID)
			else
				local leaderID = Logic.CreateEntity(Entities.CU_Evil_LeaderSkirmisher1, self.SpawnPos.X, self.SpawnPos.Y,0,2)
				for k = 1,16,1 do
					Logic.CreateEntity(Entities.CU_Evil_SoldierSkirmisher1, self.SpawnPos.X, self.SpawnPos.Y, 0, 2 )
					Logic.LeaderGetOneSoldier( leaderID )	
				end
				self:AddLeader(leaderID)
			end
			_spawnSwitch = not _spawnSwitch
		end
		if _spawnamount > 2 then
			for i = 1,1,1 do
				local trooptable = {ID = AI.Entity_CreateFormation(2, Entities.PU_LeaderHeavyCavalry2, nil, 0, self.SpawnPos.X,self.SpawnPos.Y, nil, nil, 3,0),PoisonCounter = 2}
				self:AddLeader(trooptable.ID)
				table.insert(giftreiter,trooptable)
			end
		end
	end
end